﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_01
{
    public class Main : Script
    {
/// ///////////////////////////////////// You can edit the following part ////////////////////////////////////////////////
        Keys SwitchFlyKey = Keys.Z;  // The key that switches the fly, can set to any key beside Shift, Alt or Control.
        Keys IncreaseSpeedKey = Keys.F10; // The key that increases fly speed, can set to any key beside Shift, Alt or Control.
        Keys DecreaseSpeedKey = Keys.F9; // The key that decreases fly speed, can set to any key beside Shift, Alt or Control.
        float MaxSpeed = 50.0f;  // The maximum fly speed.
        float MinSpeed = 10.0f;  // The Minimum fly speed.
        float FlySpeed = 30.0f; // The default fly speed.
/// /////////////// Dont's edit the following part unless you know what you are doing //////////////////////////////
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool FLYON = false;
        Ped FlyMount = null;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            Ped playerPed = Game.Player.Character;   
            if (FLYON)
            {
                     if (player.Character.IsInVehicle())
                     {
                            Function.Call(Hash.SET_PED_GRAVITY, playerPed, true);
                            Function.Call(Hash.SET_PED_CAN_RAGDOLL, playerPed, true);
                            Function.Call(Hash.SET_PLAYER_CAN_USE_COVER, player, true);
                            FLYON = false;
                            if (FlyMount != null)
                            {
                                   Function.Call(Hash.SET_PED_GRAVITY, FlyMount, true);                                        
                                   FlyMount = null;
                            }
	            RDR2.UI.Screen.ShowSubtitle("Cannot fly in vehicle. Fly Mode Off");
                     }
                     else
                     {
                            if (Game.IsKeyPressed(IncreaseSpeedKey) && !Game.IsKeyPressed(DecreaseSpeedKey) && FlySpeed < MaxSpeed)
                            {
                                        FlySpeed = FlySpeed + 0.5f;
                            }
                            if (!Game.IsKeyPressed(IncreaseSpeedKey) && Game.IsKeyPressed(DecreaseSpeedKey) && FlySpeed > MinSpeed)
                            {
                                        FlySpeed = FlySpeed - 0.5f;
                            }
                            Function.Call(Hash.DRAW_RECT, 0.05, 0.35, 0.00375, 0.15, 200, 240, 255, 255); 
                            Function.Call(Hash.DRAW_RECT, 0.05, 0.35, 0.0025, ((0.15 / MaxSpeed) * FlySpeed), 0, 40, 55, 255); 
                            if (FlyMount != null)
                            {
                                 if (!Function.Call<bool>(Hash.IS_PED_ON_MOUNT, playerPed))
                                 {
                                        Function.Call(Hash.SET_PED_GRAVITY, FlyMount, true); 
                                        Function.Call(Hash.SET_PED_CAN_RAGDOLL, FlyMount, true);                                       
                                        FlyMount = null;
	                        RDR2.UI.Screen.ShowSubtitle("Fly without mount.");
                                 }
                                 else
                                 {
                                      if (Game.IsKeyPressed(Keys.W))
                                      {
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, FlyMount, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_ROTATION, FlyMount, 0, 0, (NC_Get_Cam_Rotation()).Z, 2, true); 
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, FlyMount, 0, 0, 0);
                                      }
                                      if (Game.IsKeyPressed(Keys.Space))
                                      {
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, FlyMount, 1, (0), (0), (FlySpeed), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, FlyMount, 0, 0, 0);
                                      }
                                 }
                            }
                            else
                            {
                                 if (Function.Call<bool>(Hash.IS_PED_ON_MOUNT, playerPed))
                                 {
                                       FlyMount = Function.Call<Ped>(Hash.GET_MOUNT, playerPed);
                                       Function.Call(Hash.SET_PED_GRAVITY, FlyMount, false);    
                                       Function.Call(Hash.SET_PED_CAN_RAGDOLL, FlyMount, false);   
	                       RDR2.UI.Screen.ShowSubtitle("Fly with mount.");
                                 }
                                 else
                                 {
                                      if (Game.IsKeyPressed(Keys.W) && !Game.IsKeyPressed(Keys.A) && !Game.IsKeyPressed(Keys.D) && !Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, (NC_Get_Cam_Rotation()).Z, 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (!Game.IsKeyPressed(Keys.W) && Game.IsKeyPressed(Keys.A) && !Game.IsKeyPressed(Keys.D) && !Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, ((NC_Get_Cam_Rotation()).Z + 90), 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (!Game.IsKeyPressed(Keys.W) && !Game.IsKeyPressed(Keys.A) && Game.IsKeyPressed(Keys.D) && !Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, ((NC_Get_Cam_Rotation()).Z - 90), 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (!Game.IsKeyPressed(Keys.W) && !Game.IsKeyPressed(Keys.A) && !Game.IsKeyPressed(Keys.D) && Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, ((NC_Get_Cam_Rotation()).Z + 180), 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (Game.IsKeyPressed(Keys.W) && Game.IsKeyPressed(Keys.A) && !Game.IsKeyPressed(Keys.D) && !Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, ((NC_Get_Cam_Rotation()).Z + 45), 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (Game.IsKeyPressed(Keys.W) && !Game.IsKeyPressed(Keys.A) && Game.IsKeyPressed(Keys.D) && !Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, ((NC_Get_Cam_Rotation()).Z - 45), 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (!Game.IsKeyPressed(Keys.W) && Game.IsKeyPressed(Keys.A) && !Game.IsKeyPressed(Keys.D) && Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, ((NC_Get_Cam_Rotation()).Z + 135), 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (!Game.IsKeyPressed(Keys.W) && !Game.IsKeyPressed(Keys.A) && Game.IsKeyPressed(Keys.D) && Game.IsKeyPressed(Keys.S))
                                      {
                                             Function.Call(Hash.SET_ENTITY_ROTATION, playerPed, 0, 0, ((NC_Get_Cam_Rotation()).Z + 225), 2, true); 
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (FlySpeed), (0), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      if (Game.IsKeyPressed(Keys.Space))
                                      {
                                             Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (0), (FlySpeed), 0,0,0, 0, true, true, true, true, true);
                                             Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                                      }
                                      Function.Call(Hash.SET_PED_GRAVITY, playerPed, false);
                                      if (Function.Call<bool>(Hash.IS_PED_RAGDOLL, playerPed))
                                      {
                                            Vector3 currentPosition = playerPed.Position; 
                                            Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                                      }
                                      if (Function.Call<bool>(Hash.IS_PED_JUMPING, playerPed))
                                      {
                                            Vector3 currentPosition = playerPed.Position; 
                                            Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                                      }
                                 }
                            }
                     }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Alt && FLYON)
            {
                      if (FlyMount == null)
                      {
                           Function.Call(Hash.APPLY_FORCE_TO_ENTITY, playerPed, 1, (0), (0), (-1.5*FlySpeed), 0,0,0, 0, true, true, true, true, true);
                           Function.Call(Hash.SET_ENTITY_VELOCITY, playerPed, 0, 0, 0);
                      }
                      else
                      {
                           Function.Call(Hash.APPLY_FORCE_TO_ENTITY, FlyMount, 1, (0), (0), (-1.5*FlySpeed), 0,0,0, 0, true, true, true, true, true);
                           Function.Call(Hash.SET_ENTITY_VELOCITY, FlyMount, 0, 0, 0);
                      }
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == SwitchFlyKey && !e.Shift)
            {
                if (player.Character.IsInVehicle())
                {
	     RDR2.UI.Screen.ShowSubtitle("Cannot take off in vehicle.");
                }
                else
                {
                     if (FLYON)
                     {
                           Function.Call(Hash.SET_PED_GRAVITY, playerPed, true);
                           Function.Call(Hash.SET_PED_CAN_RAGDOLL, playerPed, true);
                           Function.Call(Hash.SET_PLAYER_CAN_USE_COVER, player, true);
                           FLYON = false;
                           if (FlyMount != null)
                           {
                                  Function.Call(Hash.SET_PED_GRAVITY, FlyMount, true);                                        
                                  FlyMount = null;
                           }
	           RDR2.UI.Screen.ShowSubtitle("Fly Mode Off");
                     }
                     else
                     {
                           Function.Call(Hash.SET_PED_CAN_RAGDOLL, playerPed, false);
                           Function.Call(Hash.SET_PLAYER_CAN_USE_COVER, player, false);
                           FLYON = true;
	           RDR2.UI.Screen.ShowSubtitle("Fly Mode On");
                           if (Function.Call<bool>(Hash.IS_PLAYER_CLIMBING, player))
                           {
                                  Vector3 currentPosition = playerPed.Position; 
                                  Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                           }
                           if (Function.Call<bool>(Hash.IS_PED_FALLING, playerPed))
                           {
                                  Vector3 currentPosition = playerPed.Position; 
                                  Function.Call(Hash.SET_ENTITY_COORDS, playerPed, currentPosition.X, currentPosition.Y, (currentPosition.Z - 1), true, false, false, false);
                           }
                     }
                }
            }
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
